{% set cluster = pillar.get('cluster') %}

include: 
  - templates.mongodb.common
  - templates.mongodb.replicaset
  - units.mongodb
  - units.mongodb-mms-monitoring-agent
  - units.mongodb-mms-automation-agent
  - units.munin-node
  - units.disable-transparent-hugepages
  - units.sysctl.mongodb
  - units.monrun.free_memory
  {% if 'RA' in grains['conductor']['tags'] %}
  - units.yandex-selfdns-client
  {% endif %}

{% for file in pillar.get(cluster + '-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 644 
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

{% for file in pillar.get(cluster + '-exec-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
{% endfor %}
