{% set cluster = pillar.get('cluster') %}

include: 
  - templates.mongodb.common
  - templates.mongodb.replicaset
  - units.mongodb
  - units.mongodb-mms-monitoring-agent
  - units.mongodb-mms-automation-agent
  - units.munin-node
  - units.disable-transparent-hugepages
  - units.monrun.free_memory
  - units.yandex-selfdns-client

{% for file in pillar.get(cluster + '-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

