{% set cluster = pillar.get('cluster') %}

include:
  - units.yandex-selfdns-client

config-corba-lxc:
  pkg:
    - installed

{% if grains['oscodename'] != 'precise' %}
awscli:
  pkg:
    - installed

{% if grains['oscodename'] != 'xenial' %}
python-pip:
  pkg:
    - installed

awscli_pip:
  pip.installed:
    - name: awscli

{% endif %}
{% endif %}

/etc/cron.yandex/backup-hosted-mongodb.sh:
  yafile.managed:
    - source: salt://files/disk_diskdb_dom0/etc/cron.yandex/backup-hosted-mongodb.sh
    - mode: 755
    - user: root
    - group: root
    - makedirs: True

/etc/cron.d/backup-hosted-mongodb:
  yafile.managed:
    - source: salt://files/disk_diskdb_dom0/etc/cron.d/backup-hosted-mongodb
    - mode: 644
    - user: root
    - group: root
    - makedirs: True

/etc/logrotate.d/backup-hosted-mongodb-log:
  yafile.managed:
    - source: salt://files/disk_diskdb_dom0/etc/logrotate.d/backup-hosted-mongodb-log
    - mode: 644
    - user: root
    - group: root
    - makedirs: True

/usr/bin/check-mongo-backup.sh:
  yafile.managed:
    - source: salt://files/disk_diskdb_dom0/usr/bin/check-mongo-backup.sh
    - mode: 755
    - user: root
    - group: root
    - makedirs: True

/usr/local/bin/lxc_mtn_netconfig.py:
  yafile.managed:
    - source: salt://files/disk_diskdb_dom0/usr/local/bin/lxc_mtn_netconfig.py
    - mode: 755
    - user: root
    - group: root
    - makedirs: True

mongo-backup:
  monrun.present:
    - execution_interval: 300
    - execution_timeout: 60
    - command: '/usr/bin/check-mongo-backup.sh'
    - type: common

/u0/backup:
  file.directory:
    - user: root
    - group: root
    - mode: 750
    - makedirs: True

/etc/yandex/juggler.oauth:
  file.managed:
    - contents_pillar: juggler_oauth_token
    - mode: 400
    - user: root
    - makedirs: True

/etc/yandex/aws.config:
  file.managed:
    - contents_pillar: aws_config
    - mode: 400
    - user: root
    - makedirs: True

/etc/yandex/backup_mongo_aes.key:
  file.managed:
    - contents_pillar: backup_mongo_aes_key
    - mode: 400
    - user: root
    - makedirs: True
