{% set cluster = pillar.get('cluster') %}

include:
  - units.squid3
  - units.logbackup
  - units.monrun.aws_proxy
  - units.statbox-push-client

{% for file in pillar.get( cluster + '-exec-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 755 
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

{% for file in pillar.get( cluster + '-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

haproxy:
  pkg.installed

www-data:
  user.present:
    - groups:
        - proxy
        - www-data
        
statbox-add-proxy-group:
  user.present:
    - name: statbox
    - groups:
        - proxy
        - statbox
