{% set cluster = pillar.get('cluster') %}

include:
  - templates.certificates
  - units.loggiver

{% for file in pillar.get('disk_logstore-config-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
    - follow_symlinks: True
{% endfor %}

{% for file in pillar.get('disk_logstore-exec-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
    - follow_symlinks: True
{% endfor %}

{% for file in pillar.get('disk_logstore-directories') %}
{{file}}:
  file.directory:
    - user: disk
    - group: disk
    - mode: 755
    - makedirs: True
{% endfor %}

/etc/rsyncd.secrets:
  file.managed:
    - contents: "disk:{{ pillar['rsyncd_password'] }}"
    - mode: 600
    - user: root
    - group: root
    - makedirs: True
    - follow_symlinks: True


disk_logstore-extra-pkgs:
  pkg.installed:
    - pkgs:
      {% for pkg in pillar.get('disk_logstore-extra-pkgs') %}
      - {{ pkg }}
      {% endfor %}


/u0/megagrep:
  file.directory:
    - user: root
    - group: root
    - mode: 777
    - makedirs: True

nginx:
  service:
    - running
    - reload: True
    - require:
      - pkg: nginx
  user:
    - present
    - system: True
    - groups:
      - nginx
    - require:
      - group: nginx
  group:
    - present
    - system: True
  pkg:
    - installed
    - pkgs:
      - nginx
      - nginx-common
      - nginx-full

rsync:
  service:
    - running
    - reload: True
php5-fpm:
  service:
    - running
    - reload: True


