{% set cluster = pillar.get('cluster') %}

include:
  - units.nginx
  - templates.certificates
  - units.syslog-ng
#  - units.statbox-push-client
#  - units.loggiver
#  - units.logbackup

{% for file in pillar.get(cluster + '-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

{% for file in pillar.get( cluster + '-exec-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 755 
    - user: root
    - group: root
    - makedirs: True
{% endfor %}


monrun-mpfs-api:
  monrun.present:
    - name: mpfs-api
    - execution_interval: 10
    - command: '/usr/bin/http_check.sh ping 80'

monrun-mpfs-intapi:
  monrun.present:
    - name: mpfs-intapi
    - execution_interval: 10
    - command: '/usr/bin/http_check.sh ping 8080'

mpfs-extapi-uwsgi:
    service:
          - running

mpfs-intapi-uwsgi:
    service:
          - running

monrun-lighttpd_3132:
  monrun.present:
    - name: lighttpd_3132
    - file: /etc/monrun/conf.d/lighttpd3132.conf
    - execution_interval: 300
    - command: '/usr/bin/http_check.sh ping_pattern 3333'