
{% set cluster = pillar.get('cluster') %}

include:
  - units.yandex-disk-downloader
  - units.nginx
  - units.statbox-push-client
  - units.fastcgi-blackbox-authorizer
  - units.syslog-ng
  - templates.certificates
  - templates.parsers
  - units.logbackup
  - units.yandex-hbf-agent
#  - templates.mediastorage-mulcagate
  - templates.ipvs_tun
#  - templates.lepton


{% for file in pillar.get( 'disk_downloader-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

{% for file in pillar.get( 'disk_downloader-exec-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

{% for file in pillar.get('disk_downloader-monrun-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 644 
    - user: root
    - group: root
    - makedirs: True
    - watch_in: monrun-regenerate
{% endfor %}

/etc/tvmtool/tvmtool.conf:
  file.managed:
    - contents_pillar: tvmtool-conf
    - mode: 600 
    - user: www-data
    - group: root
    - makedirs: True

monrun_tvmtool_check:
  monrun.present:
    - name: tvmtool
    - type: tvm
    - execution_interval: 30
    - command: '/usr/bin/jhttp.sh -s http -p 1488 -u /tvm/ping'

{% for link, target in pillar.get('disk_downloader-symlinks').items() %}
{{ link }}: 
  file.symlink:
    - target: {{ target }}
    - makedirs: True
    - force: True
    - require:
      - yafile: {{ target }}
{% endfor %}

{% for pkg in pillar.get('disk_downloader-additional_pkgs') %}
{{pkg}}:
  pkg:
    - installed
{% endfor %}

monrun-lighttpd_3132:
  monrun.present:
    - name: lighttpd_3132
    - file: /etc/monrun/conf.d/lighttpd3132.conf
    - execution_interval: 300
    - command: '/usr/bin/jhttp.sh -u /ping_pattern -p 3132 -t 10 --antiflap'

/etc/yabs-chkdisk-stop:
  file.absent
