{% set cluster = pillar.get('cluster') %}

include:
  - units.yandex-disk-uploader
  - units.nginx
  - units.nginx.tskv
  - units.statbox-push-client
  # - units.esets
  - units.office
  - templates.parsers
  - templates.certificates
  - units.logbackup
  - templates.ipvs_tun
  - units.yandex-disk-zookeeper-client
  - templates.mediastorage-mulcagate
  - templates.lepton
  - units.hw_watcher
  - units.yavs-docker
  - units.misc.common-parsers



{% for file in pillar.get( 'disk_uploader-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

{% for file in pillar.get( 'disk_uploader-exec-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

{% for file in pillar.get('disk_uploader-monrun-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
    - watch_in: monrun-regenerate
{% endfor %}

{% for link, target in pillar.get('disk_uploader-symlinks').items() %}
{{ link }}:
  file.symlink:
    - target: {{ target }}
    - makedirs: True
    - force: True
    - require:
      - yafile: {{ target }}
{% endfor %}

{% for pkg in pillar.get('disk_uploader-additional_pkgs') %}
{{pkg}}:
  pkg:
    - installed
{% endfor %}

monrun-lighttpd_3132:
  monrun.present:
    - name: lighttpd_3132
    - file: /etc/monrun/conf.d/lighttpd3132.conf
    - execution_interval: 300
    - command: '/usr/bin/jhttp.sh -u /ping_pattern -p 3132 -t 10 --antiflap'

/etc/yabs-chkdisk-stop:
  file.absent

/var/lib/yandex/disk/uploader:
  file.directory:
    - user: disk
    - group: disk
    - dir_mode: 775
    - makedirs: True

