{% set cluster = pillar.get('cluster') %}

include:
  - units.yadrop
  - units.statbox-push-client
  - units.nginx
  - units.logbackup
  - units.monrun.restarts
  - templates.certificates
  - templates.parsers
  - units.loggiver
  - templates.ipvs_tun
  - units.yandex-disk-zookeeper-client
  - templates.mediastorage-mulcagate
  - templates.lepton


{% for file in pillar.get('disk_webdav-files') %}
{{file}}:
  file.managed:
    - source: salt://files/disk_webdav{{file}}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

{% for file in pillar.get('disk_webdav-config-files') %}
{{file}}:
  file.managed:
    - source: salt://files/disk_webdav{{file}}
    - mode: 640
    - user: yadrop
    - group: yadrop
    - makedirs: True
{% endfor %}

disk_webdav-extra-pkgs:
  pkg.installed:
    - pkgs:
      {% for pkg in pillar.get('disk_webdav-extra-pkgs', []) %}
      - {{ pkg }}
      {% endfor %}

cert_expires:
  monrun.present:
    - execution_interval: 60
    - command: '/usr/lib/config-monrun-cert-check/cert_check_extended.sh -h localhost -p 8443 -e 14'

cert_issuer:
  monrun.present:
    - execution_interval: 60
    - command: '/usr/lib/config-monrun-cert-check/cert_check_extended.sh -h localhost -p 8443 -i "Yandex CA"'

nginx-http:
  monrun.present:
    - execution_interval: 10
    - command: '/usr/bin/jhttp.sh -s http -p 80 -u /ping'

/etc/yabs-chkdisk-stop:
  file.absent
