#!/usr/bin/env python
# -*- coding: UTF-8 -*-
import sys
from collections import Counter, defaultdict


def tskv_get_key(line, key):
    key_index = line.find('\t%s=' % key)
    return line[key_index + (len(key)+2):].split('\t')[0]


def json_get_key(obj, key):
    key_index = obj.find('\\"%s\\":' % key)
    return obj[key_index + (len(key)+5) + 2:].split('\\')[0]


def metric_name(*args):
    return '_'.join(map(str, args))


def print_codes(name, counter):
    for key, value in counter.items():
        print("%s_%s %d" % (name, key, value))


def print_timings(name, timings):
    packed_timings = map(lambda t: "%s@%s" % t, sorted(timings.items()))
    if packed_timings:
        print("@%s %s" % (name, ' '.join(packed_timings)))


results_count_codes = Counter()
results_timings = Counter()
app_prefix = 'Yandex.Disk '
app_platforms = {'android', 'ios'}
app_count_codes = Counter()
protocol_count_codes = Counter()
protocol_timings = defaultdict(Counter)
telemost_count_codes = Counter()
telemost_timings = Counter()

for line in sys.stdin:
    if not line.strip():
        continue

    u_status = tskv_get_key(line, 'status')
    a_status = u_status[0] + 'xx'
    request_time = tskv_get_key(line, 'request_time')
    results_count_codes[u_status] += 1
    results_count_codes[a_status] += 1
    results_count_codes['total'] += 1
    results_timings[request_time] += 1

    protocol = tskv_get_key(line, 'protocol').replace('/', '_')
    protocol_count_codes[metric_name(protocol, u_status)] += 1
    protocol_count_codes[metric_name(protocol, a_status)] += 1
    protocol_timings[protocol][request_time] += 1

    request = tskv_get_key(line, 'request')
    if request.startswith('/telemost_front/'):
        telemost_count_codes[u_status] += 1
        telemost_count_codes[a_status] += 1
        telemost_count_codes['total'] += 1
        telemost_timings[request_time] += 1

    user_agent = tskv_get_key(line, 'user_agent')
    if user_agent.startswith(app_prefix):
        user_agent_info = user_agent[len(app_prefix):]
        os = json_get_key(user_agent_info, 'os').split()[0].lower()
        if os in app_platforms:
            vsn = json_get_key(user_agent_info, 'vsn')
            version = metric_name(os, vsn)
            app_count_codes[metric_name(version, u_status)] += 1
            app_count_codes[metric_name(version, a_status)] += 1


print_codes("nginx_count_request_total_acode", results_count_codes)
print_timings("nginx_timings_total", results_timings)
print_codes("telemost_codes", telemost_count_codes)
print_timings("telemost_timings", telemost_timings)
print_codes("app_count_codes", app_count_codes)
print_codes("protocol_count_codes", protocol_count_codes)

for key, timings in protocol_timings.items():
    print_timings("protocol_timings_%s" % key, results_timings)
