#!/usr/bin/env python

import json
import sys
from collections import defaultdict, Counter

res = defaultdict(list)

for line in sys.stdin:
        try:
                data = json.loads(line.strip())
        except ValueError:
                continue

        # rating part
        if 'rating' in data:
                res['conference_rating_hgram'].append(data['rating'])

        # client statistics part
        elif 'standard' in data:
                for mtype in ('audio', 'video'):
                        stat = data['standard'].get('inbound_rtp_%s_streams' % mtype, [])
                        for row in stat:
                                if row.get('bytes_received'):
                                        if row.get('packets_received'):
                                                received = row.get('packets_received')
                                                lost = row.get('packets_lost', 0)

                                                res['%s_packets_loss_perc_hgram' % mtype].append(
                                                    100.0 * lost / ((received + lost) or 1)
                                                )

                                        if mtype == 'video':
                                                track = row.get('video_track', {})
                                                if track and track.get('frames_received'):
                                                        dropped = track.get('frames_dropped', 0)
                                                        received = track.get('frames_received')

                                                        res['video_frames_drop_perc_hgram'].append(
                                                            100.0 * dropped / ((dropped + received) or 1)
                                                        )
                rtt = data['standard'].get\
                        ('transport', {}).get\
                        ('selected_candidate_pair', {}).get\
                        ('current_round_trip_time')
                if rtt:
                        res['rtt_hgram'].append(rtt)



for metric, values in res.items():
        cnt = Counter([round(v, 3) for v in values])
        values = ['%s@%s' % i for i in cnt.items()]
        print('@%s %s' % (metric, ' '.join(values)))
