#!/usr/bin/env python

import re
import sys
from collections import defaultdict, Counter

res = defaultdict(Counter)

patterns = {k: re.compile(v) for k, v in {
    '/v1/telemost/conferences': '^/v1/telemost/conferences$',
    '/v2/telemost/conferences': '^/v2/telemost/conferences$',
    '/v2/telemost/conferences/uri': '^/v2/telemost/conferences/[^/]+$',
    '/v2/telemost/users/me': '^/v2/telemost/users/me',
    '/v2/telemost/conferences/uri/link-calendar-event': '^/v2/telemost/conferences/[^/]+/link-calendar-event$',
    '/telemost_front/v2/telemost/conferences/uri/connection': '^/telemost_front/v2/telemost/conferences/[^/]+/connection$',
    '/telemost_front/v2/telemost/conferences/uri/peers': '^/telemost_front/v2/telemost/conferences/[^/]+/peers$',
}.items()}

codes = {
    100: '1xx',
    200: '2xx',
    300: '3xx',
    400: '4xx',
    500: '5xx',
}

for line in sys.stdin:
    if not line:
        continue
    line = line.split(' ', 1)
    try:
        status = (int(line[0]) // 100) * 100
    except:
        continue
    uri = line[1]

    for key, pattern in patterns.items():
        if pattern.match(uri):
            res[key][status] += 1

for handle, handles in res.items():
    for code, cnt in handles.items():
        message = "{}_{} {}".format(handle.replace("/", "_").strip("_"), codes.get(code, "-"), cnt)
        print(message)

