#!/usr/bin/env python

import re
import sys

from collections import Counter

cnt = Counter()

link_map = {
        r'/telemost_front/v1/telemost/conferences/?$': 'conference_create',
        r'/telemost_front/v1/telemost/conferences/\S+': 'conference_join',
}

for line in sys.stdin:
        line = line.strip()
        for link, action in link_map.items():
                if re.search(link, line):
                        cnt[action] += 1
                        continue

for k, v in cnt.items():
        print('%s %s' % (k, v))
