#!/bin/bash

BACKUP_DAYS=5
ENDPOINT_URL="https://s3.mds.yandex.net"
AWS_CMD="aws --endpoint-url=${ENDPOINT_URL} s3"
export AWS_CONFIG_FILE="/etc/yandex/aws.config"
message=""
status="0"

t_bkp_name="shard.dump.$(date -d today -Idate).tar.gz"
db_hosts=$(/usr/bin/lxctl list | awk '$3=="running" || $3=="b" {print $1}' | grep hidden)
for db_host in $db_hosts; do
    bucket_name="s3://disk-backup-mongo/backup/$db_host/"
    backups_count=$($AWS_CMD ls "$bucket_name" 2>/dev/null | wc -l)
    if [ $backups_count -lt $BACKUP_DAYS ]; then
        message="$message $backups_count for $db_host"
        status="2"
    fi
done

echo "$status;$message"
