
log_message = function (level, message) {
    level = level || 0;
    var dt = new Date();
    print (dt + " " + message);
}   

set_plan_cache_filter_subscription = function () {
    var set_plan_cache = db.runCommand ({ planCacheSetFilter: "subscription", "query": { "url": "http://xivahub.mail.yandex.net:80/notify/disk-json", "uid": "35750139" }, "indexes": [{"uid" : 1}]});
    log_message (10, (set_plan_cache.ok == 1) ? "OK: successful set planCacheSetFilter for subscription" : "FAILED: can not set planCacheSetFilter for subscription");
    return ! set_plan_cache.ok; 
}


check_plan_cache_filter_subscription = function (plan_caches) {
    var rval = 1;
    plan_caches.forEach(function (pc)  {
        if (pc.query.uid == "35750139" && pc.query.url == "http://xivahub.mail.yandex.net:80/notify/disk-json" &&  
            pc.indexes[0].uid == 1  && pc.indexes.length == 1 ) {            
            rval = 0;
            return;
        }
    });
    return rval;
}


check_plan_cache_filters = function (fix_plan_cache_filters) {
    fix_plan_cache_filters = fix_plan_cache_filters || 0;

    var plan_caches = db.runCommand( { planCacheListFilters: "subscription"}).filters;

    if (!plan_caches || plan_caches.length < 1) {
        // set all
        log_message (0, "miss: planCacheListFilters do not exist");
        if ( fix_plan_cache_filters ) { 
            set_plan_cache_filter_subscription();
        } 
    } else {
        if (check_plan_cache_filter_subscription(plan_caches) == 0) {
            log_message (0, "ok: planCacheListFilter for subsriptions exists");            
        } else {
            message (0, "miss: planCacheListFilter for subsriptions does not exist");
            if ( fix_plan_cache_filters ) {
                set_plan_cache_filter_subscription();                
            }
        }

    }
}

rs.slaveOk();

db_table = "mpfs_subscriptions.subscription";
var subscriptions_exists = db.system.namespaces.find( { "name": db_table } ).count();
if (subscriptions_exists == 1) {
    check_plan_cache_filters(fix_plan_cache_filters);
} else {
    log_message (1, "warn: " + db_table + " does not exist on this server");
}


