import os
import sys
import time
import socket
import re

hostname = socket.gethostname()

def application(environ, start_response):
	headers = [('Content-type', 'text/plain')]

	if environ['PATH_INFO'] == '/ping':
		start_response('200 OK', headers)
		return ["pong\n"]

	elif environ['PATH_INFO'] == '/store_log':
		request_body_size = int(environ['CONTENT_LENGTH'])

		if request_body_size == 0:
			start_response('500', headers)
			return ["empty request_body_size\n"]

		try:
			request_body = environ['wsgi.input'].read(request_body_size)

			try:
				leng = len(environ['HTTP_X_FILENAME'])
			except KeyError:
				leng = 0

			if leng > 0:
				index_re = re.compile('^([0-9a-zA-Z\.\-\_]+)$')
				matches = index_re.findall(environ['HTTP_X_FILENAME'])
				if len(matches):
					dstfile = '/u0/disk_logs/%s' % environ['HTTP_X_FILENAME']
				else:
					start_response('500 Error', headers)
					return ["Cant parse X-Filename header: %s\n" % environ['HTTP_X_FILENAME']]

				fout = open(dstfile, 'wb')
				fout.write(request_body)
				fout.close()

				start_response('200 OK', headers)
				return ["http://%s:8081/%s" % (hostname, environ['HTTP_X_FILENAME'])]
			else:
				t1 = time.strftime('%Y-%m-%d')
				dstdir = '/u0/disk_logs/%s' % (t1)

				if not os.path.exists(dstdir):
					os.makedirs(dstdir)

				#d = dict([x.split("=") for x in environ['QUERY_STRING'].split("&")])
				#dstfile = os.path.join('/u0/dlogs', d['id'] + '.zip')

				t2 = time.time()
				dstfile = '%s/%f.zip' % (dstdir, t2)

				fout = open(dstfile, 'wb')
				fout.write(request_body)
				fout.close()

				start_response('200 OK', headers)
				return ["http://%s:8081/%s/%f.zip" % (hostname, t1, t2)]

		except:
			start_response('500 Error', headers)
			return ["Internal error"]

	else:
		start_response('500 Error', headers)
		return ["Hand not found"]
