#!/bin/bash

base="/u0/archive_logs/"
test -d "$base" || mkdir "$base" || { echo "cant create $base"; exit 1; }

test -x /usr/bin/curl || { echo "install or chmod curl"  && exit 1; }

# fetch disk groups
curl "http://c.yandex-team.ru/api/projects2groups/disk" 2>/dev/null > /tmp/groups
curl "http://c.yandex-team.ru/api/projects2groups/sync" 2>/dev/null >> /tmp/groups

grep -q html /tmp/groups && { echo "tags found, cant fetch groups"; exit 1; }

echo "mail_av" >> /tmp/groups
echo "mail_docback" >> /tmp/groups
echo "mail_docfront" >> /tmp/groups
echo "mail_docfront_qa" >> /tmp/groups
echo "mail_docfrontcorp" >> /tmp/groups
echo "mail_docfrontcorp_qa" >> /tmp/groups
echo "mail_sasulca" >> /tmp/groups
echo "mail_searchdb" >> /tmp/groups
echo "mail_search" >> /tmp/groups
echo "mail_mulca" >> /tmp/groups

if [ -s "/tmp/groups" ]; then
	groups=(`cat /tmp/groups | xargs`)
else
	echo "fetch null file, exit"
	exit 1
fi

# and scan it
for (( i=0;i<${#groups[*]};i++)); do

	group="`echo ${groups[$i]}|sed -e "s/disk_//g"|sed -e "s/mail_//g"`"

	if ! [ -d "$base/$group" ]; then
		mkdir "$base/$group" || { echo "cant create $base/$group"; exit 1; }
		chown ftp:ftp "$base/$group" || { echo "cant chown $base/$group"; exit 1; }
	fi

	test -f "/tmp/hosts" && rm "/tmp/hosts"

	# get hosts
	curl "http://c.yandex-team.ru/api/groups2hosts/${groups[$i]}" 2>/dev/null > /tmp/hosts

	grep -q html /tmp/hosts && { echo "tags found"; exit 1; }

	if [ -s "/tmp/hosts" ]; then
		cat /tmp/hosts | while read host; do
			host="`echo "$host" | awk 'BEGIN{FS="."}{print $1}'`"
			if ! [ -d "$base/$group/$host" ]; then
				mkdir "$base/$group/$host" || { echo "cant create $base/$group/$host"; exit 1; }
				chown ftp:ftp "$base/$group/$host" || { echo "cant chown $base/$group/$host"; exit 1; }
			fi
		done
	else
		echo -n
#		echo "cant find /tmp/hosts or it blank for group $group at $dc";
#		exit 1;
	fi
done

