#!/bin/bash

CLUSTERS="lb proxy"
LOGTYPE="ydisk-proxy-access-log"
LB_HOST="logbroker.yandex.net"

yesterday=$(date --date="yesterday" +'%Y%m%d')

for c in $CLUSTERS; do
  ident="disk-${c}"
  logfiles=($(find "/u0/archive_logs/$c" -name "squid3_access-tskv.log.${yesterday}.gz" -type f))
  echo "${#logfiles[@]} logfiles found for cluster disk_${c}"

  for log in "${logfiles[@]}"; do
    echo "processing file: $log"
    zcat $log | push-client -f --cron --ident="$ident" --logtype="$LOGTYPE" --stdin --network:master-addr="$LB_HOST" --watcher:state=temp-state --network:proto=rt
  done

done
