#!/usr/bin/env python

# -*- coding: UTF-8 -*-

import os
import re
import sys
import pprint
from collections import defaultdict


results_errors = { 'parse' : 0 }

s_name = 'nginx';

results_count_urls_codes = dict() 
results_count_urls_acodes = dict()

results_timings_urls_all = dict()
results_timings_urls_total = list()

#index_re = 'client [A-Z]+ "https?://(?P<b_host>[^\/:]+)[^"]+" (?P<b_status>\d+) \d+ \d+ (?P<b_request_time>\d+\.\d+)'

for line in sys.stdin:
#    print line

    parts = line.strip("\n").split("\t")
    parsed = {}; 
    for part in parts:
        eq = part.find('=')
        key = part[:eq]
        value = part[(eq+1):]
        parsed[key] = value 


###  FIXME
#    matches = re.search(index_re, line)
#    pprint.pprint(matches.groups())
#    if matches:
    if True:
        u_url = 'fixme'
        u_status = int(parsed['status'])


        if u_url not in results_count_urls_codes:
            results_count_urls_codes[u_url] = dict()

        if u_status not in results_count_urls_codes[u_url]:
            results_count_urls_codes[u_url][u_status] = 0
        
        if u_url not in results_timings_urls_all:
            results_timings_urls_all[u_url] = list()

      
        results_timings_urls_all[u_url].append(parsed['request_time'])
        results_count_urls_codes[u_url][u_status] += 1

    else:
        results_errors['parse'] += 1
        continue

# aggregate
results_count_urls_acodes['total'] = dict()
for u_url in ['total', '2xx', '3xx', '4xx', '5xx']:
    results_count_urls_acodes['total'][u_url] = 0    
    

for u_url, result in sorted(results_count_urls_codes.items()):
    if u_url not in results_count_urls_acodes:
        results_count_urls_acodes[u_url] = dict()
        results_count_urls_acodes[u_url]['total'] = 0
    for u_status_k, u_status_v in sorted (result.items()):

        acode = str(u_status_k / 100) + 'xx'
        
        if u_status not in results_count_urls_acodes[u_url]:
            results_count_urls_acodes[u_url][acode] = 0 

        results_count_urls_acodes[u_url][acode] += u_status_v
        results_count_urls_acodes[u_url]['total'] += u_status_v

        results_count_urls_acodes['total'][acode] += u_status_v
        results_count_urls_acodes['total']['total'] += u_status_v

    
# count_urls_codes (codes per url)
for u_url, result in sorted(results_count_urls_codes.items()):
    for u_status_k, u_status_v in sorted (result.items()):
        print("%s_count_request_%s_code_%s %d" % (s_name, u_url, u_status_k, u_status_v))

print
# count_urls_codes (codes per url)
for u_url, result in sorted(results_count_urls_acodes.items()):
    for u_status_k, u_status_v in sorted (result.items()):
        print("%s_count_request_%s_acode_%s %d" % (s_name, u_url, u_status_k, u_status_v))

print
for u_url, timings in sorted(results_timings_urls_all.items()):
    if len(timings):
        results_timings_urls_total.extend(timings)
        print("%s_timings_request_%s %s" % (s_name, u_url, ' '.join(timings) ))

if len(results_timings_urls_total):
    print("%s_timings_%s %s" % (s_name, 'total', ' '.join(results_timings_urls_total) ))

for error, value in sorted(results_errors.items()):
    print("%s_error_%s %d" % (s_name, error, value))



sys.exit(0)

