#!/bin/bash


function log_message
{
    echo "[$(date +'%Y-%m-%d %H:%M:%S')] $1" >> "$log_file"
}


function downtime_host
{
    OK=0
    hostname=$1
    dt_hours=$2
    for host in ${jctl_hosts[*]}; do
        log_message "Trying to downtime $hostname for $dt_hours hours at $host"
        curl -ks "http://${host}:8998/api/downtimes/set_downtime?do=1&object_name=$hostname&end_time=%2B${dt_hours}hours&description=${dt_description}"; echo
        OK=$?
        if [[ ${OK} == 0 ]]; then
            break
        fi
    done
    return $OK
}

function remove_downtime
{
    OK=0
    hostname=$1
    for host in ${jctl_hosts[*]}; do
        log_message "Trying to remove $hostname downtime at $host"
        curl -ks "http://${host}:8998/api/downtimes/remove_downtime?do=1&object_name=$hostname"; echo
        OK=$?
        if [[ ${OK} == 0 ]]; then
            break
        fi
    done
    return $OK
}


log_file="/var/log/automongobackup.log"

jctl_hosts_backup=("jmon01e.media.yandex.net" "jmon01g.media.yandex.net" "jmon01h.media.yandex.net")
jctl_hosts=( $(curl -ks 'http://c.yandex-team.ru/api-cached/groups2hosts/media-jmon') )
jctl_hosts="${jctl_hosts:-$jctl_hosts_backup}"

dt_hours_backup=10
dt_hours_repl_lag=3

dt_description="syncdb-hidden backup"

# backup max age in days
backup_max_age=3


date=`date "+%Y%m%d"`
dpath="/u0/"
vhost=`hostname`

dfile="$dpath/$date.tar.gz"
spath="/opt/mongodb/"

sleep_sec=$((RANDOM%7200))


log_message "Purging backups older ${backup_max_age}"
find /u0/* -mtime +${backup_max_age} -delete


log_message "Sleep for ${sleep_sec}"
sleep ${sleep_sec}


log_message "Setting downtime for backup (${dt_hours_backup} hours)"
downtime_host $vhost $dt_hours_backup


log_message "Shutting down mongodb"
service mongodb stop


log_message "Creating backup archive ($dfile)"
#old cmd: tar -cz "$spath" -f "$dfile"
(cd $spath ; tar cvf - . | pigz -p 4 -c > "${dfile}" )


log_message "Starting mongodb"
service mongodb start


log_message "Removing downtime for backup"
remove_downtime $vhost 


log_message "Setting downtime for replica sync (${dt_hours_repl_lag} hours)"
downtime_host $vhost $dt_hours_repl_lag


