{% set cluster = pillar.get('cluster') %}
{% set unit = 'abyssync' %}

{% for file in pillar.get(unit + '-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
    - template: jinja
{% endfor %}

abyssync:
  service:
    - running
    - require:
      - pkg: abyssync
  pkg.installed:
    - name: abyssync
