{% set cluster = pillar.get('cluster') %}
{% set unit = 'atop' %}

{% for file in pillar.get(unit + '-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

/etc/init/atop.conf:
  file.absent

/etc/init.d/atop:
  yafile.managed:
    - source: salt://units/{{ unit }}/files/etc/init.d/atop
    - mode: 755 
    - user: root
    - group: root
    - makedirs: True
    - follow_symlinks: False

atop:
  service:
    - running
    - require:
      - pkg: atop
  pkg:
    - installed
