{% set cluster = pillar.get('cluster') %}
{% set unit = 'cgroups' %}


/etc/cgrules.conf:
  yafile.managed:
    - source: salt://units/{{ unit }}/files/etc/cgrules.conf
    - template: jinja
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
    - watch_in: cgred


/etc/default/cgrulesengd:
  yafile.managed:
    - source: salt://units/{{ unit }}/files/etc/default/cgrulesengd
    - mode: 755 
    - user: root
    - group: root
    - makedirs: True
    - watch_in: cgred


cgred:
  file.managed:
    - name: /etc/init/cgred.conf
    - source: salt://units/{{ unit }}/files/etc/init/cgred.conf
    - require_in:
      - service: cgred
  service.running:
    - enable: True
    - require:
      - file: cgred
      - pkg: cgred
    - watch:
      - yafile: /etc/cgrules.conf
  pkg.installed:
    - pkgs:
      - cgroup-bin
      - libcgroup1

  

