{% set cluster = pillar.get('cluster') %}
{% set unit = 'cgroups' %}


{% for file in pillar.get('cgroups-cgconfig-files', {}) %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - template: jinja
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
    - watch_in:
      - service: cgroup-lite
{% endfor %}


cgroup-lite:
  file.managed:
    - name: /etc/init/cgroup-lite.conf
    - source: salt://units/{{ unit }}/files/etc/init/cgroup-lite.conf
    - require:
      - pkg: cgroup-lite
  service.running:
    - enable: True
    - require:
      - file: cgroup-lite
      - pkg: cgroup-lite
  pkg.installed:
    - pkgs:
      - cgroup-bin
      - libcgroup1

