#!/bin/bash

die () {
    echo "$1;$2"
    exit 0
}

while getopts "r:w:c:n:e:f:" OPTION
do
    case $OPTION in
        w)
            WARN_LIMIT="$OPTARG"
        ;;
        c)
            CRIT_LIMIT="$OPTARG"
        ;;
        n)
            WATCH_SECONDS="$OPTARG"
        ;;
        r)
            REGEX="$OPTARG"
        ;;
        e)
            EXCLUDE="$OPTARG"
        ;;
        f)
            FILE="$OPTARG"
        ;;
    esac
done

warn_limit=${WARN_LIMIT:-'6'}
crit_limit=${CRIT_LIMIT:-'60'}
watch_seconds=${WATCH_SECONDS:-600}
regex=${REGEX:-'([0-9]{4}\.[0-9]{2}\.[0-9]{2}\ [0-9]{2}\:[0-9]{2}\:[0-9]{2})'}
exclude=${EXCLUDE:-'^$'}
logfile=${LOGFILE:-'/var/log/clickhouse-server/clickhouse-server.err.log'}

error_count=$(sudo -u clickhouse timetail -n "$watch_seconds" -r "$regex" "$logfile" 2>&1 | grep -vP "$exclude" | fgrep -c '<Error>')

if [ "$error_count" -gt "$crit_limit" ] ; then
    die 2 "$error_count errors for last $watch_seconds seconds"
elif [ "$error_count" -gt "$warn_limit" ] ; then
    die 1 "$error_count errors for last $watch_seconds seconds"
else
    die 0 OK
fi
