{% set cluster = pillar.get('cluster') %}
{% set unit = 'clickhouse' %}

{% for file in pillar.get('clickhouse-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 400
    - user: clickhouse
    - group: clickhouse
    - template: jinja
    - makedirs: True
{% endfor %}

{% for file in pillar.get(unit + '-monrun-files', []) %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
    - watch_in: monrun-regenerate
{% endfor %}

{% for file in pillar.get(unit + '-exec-files', []) %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

/var/lib/clickhouse/access/:
  file.directory:
    - user: clickhouse
    - group: clickhouse
    - mode: 750
    - makedirs: True

clickhouse_repo:
  pkgrepo.managed:
    - humanname: clickhouse
    - name: deb http://repo.yandex.ru/clickhouse/deb/stable/ main/
    - file: /etc/apt/sources.list.d/clickhouse.list
    - refresh_db: true
    - require_in:
      -pkg: clickhouse_packages 

clickhouse_packages:
  pkg.installed:
    - pkgs:
      - clickhouse-client: 21.12.2.17
      - clickhouse-server: 21.12.2.17
      - clickhouse-common-static: 21.12.2.17
      - python3.5
      - python3-requests

clickhouse-server:
  service.running:
    - watch:
      - pkg: clickhouse_packages
