#!/bin/bash
set -e

DAYS_DEPTH=${1:-30} # default = 30 days
COREDUMPS_PATH=$(sysctl -n kernel.core_pattern)
COREDUMPS_DIR=$(dirname "$COREDUMPS_PATH")
COREDUMPS_BASENAME=$(basename "${COREDUMPS_PATH%%.*}")
if [ -z "$COREDUMPS_BASENAME" ] || [ "$COREDUMPS_BASENAME" == "*" ] || [ "$COREDUMPS_BASENAME" == "/" ]; then
	>&2 echo "Bad coredumps basename. Stop for safety"
	exit 2
fi

COREDUMPS_MASK="${COREDUMPS_BASENAME}.*"

find $COREDUMPS_DIR -name "$COREDUMPS_MASK" -mtime +$DAYS_DEPTH -delete
