{% set cluster = pillar.get('cluster') %}
{% set unit = 'envoy-local-balancer' %}
{% from slspath + '/map.jinja' import envoy with context %}

getenvoy-envoy:
    pkg.installed:
        - refresh: true
        - version: 1.14.1.p0.g3504d40-1p63.g902f20f.yandex0

{% for name,entry in pillar.get(unit + '-config-files', {}).items() %}
{% for file in entry['files'] %}
{{file}}:
  yafile.managed:
    - source: salt://{{ entry['basedir'] }}{{ file }}
    - template: jinja
    - mode: 644 
    - user: root
    - group: root
    - makedirs: True
    - template: jinja
    - context:
        envoy: {{ envoy }}
{% endfor %}
{% endfor %}

{% for name,entry in pillar.get(unit + '-exec-files', {}).items() %}
{% for file in entry['files'] %}
{{file}}:
  yafile.managed:
    - source: salt://{{ entry['basedir'] }}{{ file }}
    - template: jinja
    - mode: 755 
    - user: root
    - group: root
    - makedirs: True
    - template: jinja
    - context:
        envoy: {{ envoy }}
{% endfor %}
{% endfor %}

/var/log/ubic/envoy:
    file.directory:
    - user: root
    - group: root
    - makedirs: True

/var/log/envoy:
    file.directory:
    - user: root
    - group: root
    - makedirs: True

/etc/hosts.manual:
    yafile.managed:
        - source: salt://units/{{ unit }}/files/etc/hosts.manual
        - template: jinja
        - mode: 644
        - user: root
        - group: root
        - makedirs: True
        - template: jinja
        - context:
            envoy: {{ envoy }}
    cmd.run:
        - name: /etc/init.d/fixhosts start
        - onchanges:
          - yafile: /etc/hosts.manual


/etc/nginx/sites-enabled/local_balancer.conf:
    file.absent

envoy:
  service:
    - running