{% set cluster = pillar.get('cluster') %}
{% set unit = 'erateserver' %}

{#
{% for file in pillar.get('erateserver-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
{% endfor %}
#}

{% for file in pillar.get('erateserver-config-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 644 
    - user: root
    - group: root
    - makedirs: True
    - watch_in:
      - service: erateserver
{% endfor %}

{% for file in pillar.get('erateserver-exec-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

erateserver-groups-status:
  monrun.present:
    - command: '/usr/bin/erateserver-status-check.sh'
    - execution_interval: 60
    - execution_timeout: 1
    - type: erateserver

erateserver:
  pkg:
    - installed
    - pkgs:
      - erateserver
      - timelimit
  service:
    - running
    - require:
      - pkg: erateserver
      - user: erateserver
      - group: erateserver
  user:
    - present
    - system: True
    - createhome: True
    - home: '/var/lib/erateserver'
    - groups:
      - erateserver
    - require:
      - group: erateserver
  group: 
    - present
    - system: True
  monrun.present:
    - command: '/usr/bin/http_check.sh ping 1880'
    - execution_interval: 60
    - execution_timeout: 1
    - type: erateserver


