{% set cluster = pillar.get('cluster') %}
{% set unit = 'hw_watcher' %}

/etc/hw_watcher/conf.d/token.conf:
  yafile.managed:
    - template: jinja
    - source: salt://units/hw_watcher/files/etc/hw_watcher/conf.d/token.conf
    - mode: 400
    - user: hw-watcher
    - group: hw-watcher

/etc/hw_watcher/conf.d/bmc.conf:
  yafile.managed:
    - source: salt://units/hw_watcher/files/etc/hw_watcher/conf.d/bmc.conf
    - mode: 644
    - user: root
    - group: root
    
/etc/yandex/hw_watcher/hw_watcher.conf.disk override:
  yafile.managed:
    - name: /etc/yandex/hw_watcher/hw_watcher.conf.disk
    - template: jinja
    - source: salt://units/hw_watcher/files/etc/yandex/hw_watcher/hw_watcher.conf.disk
    - mode: 644
    - user: root
    - group: root

  cmd.run:
    - name: /usr/bin/update-hw-watcher-conf.sh
    - onchanges:
      - yafile: /etc/yandex/hw_watcher/hw_watcher.conf.disk
