{% set cluster = pillar.get('cluster') %}
{% set unit = 'iptables-persistent' %}

{% for file in pillar.get('iptables-persistent-config-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
    - watch_in: iptables-persistent-reload-cmd
{% endfor %}

iptables-persistent-reload-cmd:
  cmd.wait:
    - name: '/etc/init.d/iptables-persistent reload'
    - cwd: /

iptables-persistent:
  service.enabled:
    - require:
      - pkg: iptables-persistent
  pkg.installed:
    - pkgs:
      - iptables-persistent


