#!/usr/bin/python
import re
import urllib2
import argparse
from collections import Counter
from urllib import urlencode

#./logbroker_lag.py disk-event-loader ydisk-event-history-log
#http://$dc.logbroker.yandex.net/pull/offsets?client=disk-event-loader&log-type=ydisk-event-history-log&dc=$dc

LBPORT = 8999
lb_dc_list = ['myt', 'sas', 'man', 'iva', 'vla']

parser = argparse.ArgumentParser()
parser.add_argument("--client", required=True)
parser.add_argument("--log-type", required=True, dest='log-type')
parser.add_argument("--ident")

args = parser.parse_args()

# getting args as dict
opts = vars(args)

# filtering unset parameters
opts = {k: v for k, v in opts.items() if v is not None}


def http_get(url, retries, req_timeout):
    bdata = False
    for i in xrange(retries):
        try:
            http_req = urllib2.urlopen(url, timeout=req_timeout)
            if http_req.getcode() != 200:
                bdata = False
            else:
                bdata = http_req.read()
                break
        except:
            bdata = False
    return bdata


dc_lags = {}
local_lags = []


for lb_query_dc in lb_dc_list:
    lags = Counter()
    query_opts = urlencode(opts)
    request_url = 'http://{}.logbroker.yandex.net:{}/pull/offsets?{}'.format(lb_query_dc, LBPORT, query_opts)
    lb_query_data = http_get(request_url, 2, 5)

    if lb_query_data:
        for line in lb_query_data.splitlines():
            try:
                (topic_partition, offsets, logstart, logsize, lag, owner) = line.split()
            except ValueError:
                continue
            dc_match = re.match(r'.+\.([a-z]+).*', topic_partition)
            dc = dc_match.group(1)
            if lag.isdigit():
                lags[dc] += int(lag)
        dc_lags[lb_query_dc] = lags
        local_lags.append(lags[lb_query_dc])

for (lb_dc, lags) in dc_lags.iteritems():
    for (dc, lag) in lags.iteritems():
        print '{}_{} {}'.format(lb_dc, dc, lag)

print 'max_local_lag {}'.format(max(local_lags))
