#!/bin/bash

CHECK_URL=$1
SQUID_VIPS="5.45.202.22 5.45.202.23"
HAPROXY_VIPS="5.45.202.26 5.45.202.27"

#
# Testing squid proxy
#

for SQUID_IP in $SQUID_VIPS; do
  curl -s -f --proxy "${SQUID_IP}:443" "${CHECK_URL}" > /dev/null || SQUID_STATUS="FAILED"
done
SQUID_STATUS=${SQUID_STATUS:-"OK"}



#
# Testing haproxy sni
#

CHECK_HOSTNNAME=$(echo "$CHECK_URL" | cut -f 3 -d "/")

for HAPROXY_IP in $HAPROXY_VIPS; do
  curl -s -f --resolve "${CHECK_HOSTNNAME}:443:${HAPROXY_IP}" "${CHECK_URL}" > /dev/null || HAPROXY_STATUS="FAILED"
done
HAPROXY_STATUS=${HAPROXY_STATUS:-"OK"}


#
# Final status
#

if [ $SQUID_STATUS == "OK" ] && [ $HAPROXY_STATUS == "OK" ]; then
  echo "0;OK"
else
  echo "2;squid3:${SQUID_STATUS} and haproxy:${HAPROXY_STATUS}"
fi
