#!/bin/bash
set -e


while getopts p:d: option
do
  case "$option" in
    p)
       CERT_PATH=$OPTARG
       ;;
    d)
       ALARM_DAYS=$OPTARG
       ;;
  esac
done


ALL_CERTS=$(find "$CERT_PATH" \( -name   '*.pem*' -o -name '*.crt*' \))
BAD_CERTS=()


for CERT_FILE in $ALL_CERTS
  do
    if ! openssl x509 -in "$CERT_FILE" -noout -checkend $(($ALARM_DAYS*86400)); then
      BAD_CERTS+=("$CERT_FILE")
    fi
done

if [ ${#BAD_CERTS[@]} -ne 0 ]; then
  echo "2;${#BAD_CERTS[@]} certs in $CERT_PATH directory will expire in $ALARM_DAYS days."
else
  echo "0; Ok"
fi
