
{% set config = pillar.get('free_memory', { 'warn_limit_mb' : 10240 , 'crit_limit_mb' : 5120}) -%}


free_memory:
  monrun.present:
    - execution_interval: 60
    - execution_timeout: 15
    - command: /usr/bin/free_memory.sh {{ config['warn_limit_mb'] }} {{ config['crit_limit_mb'] }}

/usr/bin/free_memory.sh:
  file.managed:
    - source: salt://units/monrun/files/usr/bin/free_memory.sh
    - mode: 755
    - user: root
    - group: root
    - makedirs: True


