{% for log_type, entry in pillar.get('logbroker_lag_monitoring', {}).items() %}
logbroker_per_partition_lag_{{ log_type }}:
  monrun.present:
    - execution_interval: 600
    - execution_timeout: 300
  {% if entry['ident'] is defined %}
    - command: 'sudo -u monitor /usr/local/bin/logbroker_per_partition_lag.py --client {{ entry['client'] }} --log-type {{ log_type }} --threshold {{ entry['threshold'] }} --ident {{ entry['ident'] }}'
  {% else %}
    - command: 'sudo -u monitor /usr/local/bin/logbroker_per_partition_lag.py --client {{ entry['client'] }} --log-type {{ log_type }} --threshold {{ entry['threshold'] }}'
  {% endif  %}
{% endfor %}

/usr/local/bin/logbroker_per_partition_lag.py:
  file.managed:
    - source: salt://units/monrun/files/usr/local/bin/logbroker_per_partition_lag.py
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
