#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Получает все статус коды ручки billing/buy из лога /var/log/mpfs/access-tskv.log
за последний час и выдает статистику.
"""

import collections
import subprocess


HTTP_STATUS_CODES = (
    range(100, 103) + range(200, 209) + [226] + range(300, 309) +
    range(400, 419) + range(421, 425) + [426, 428, 429, 431, 444, 449, 451] +
    range(500, 512) + range(520, 527)
)


def main(_input):
    data = collections.defaultdict(int)

    for http_status_code in HTTP_STATUS_CODES:
        data[str(http_status_code)] = 0
    data['1xx'] = 0
    data['2xx'] = 0
    data['3xx'] = 0
    data['4xx'] = 0
    data['5xx'] = 0

    for raw in _input:
        raw = raw.strip()
        if not raw:
            continue

        status_code = raw
        data[status_code] += 1
        data['%sxx' % status_code[0]] += 1

    data['non_2xx'] = data['1xx'] + data['3xx'] + data['4xx'] + data['5xx']

    for key in sorted(data):
        print key, data[key]

if __name__ == '__main__':
    _input = subprocess.check_output(
        "/usr/bin/timetail -n 3600 -t tskv  /var/log/nginx/mpfs/tskv.log | "
        "grep 'billing/buy' | egrep -wo 'status=[0-9]+' | sed -e 's/status=//g'",
        shell=True, stderr=subprocess.STDOUT
    )
    main(_input.split())
