#!/usr/bin/python

import sys
from collections import Counter

error_counters = Counter()
errors_per_shard = Counter()

for line in sys.stdin:
    line = line.strip()

    if not line:
        continue

    if '\tmodule=shard_status\t' not in line:
        continue

    message_index = line.find('\tmessage=')
    message = line[message_index + 9:].split('\t')[0]
    message = message.split()

    error = message[-2]
    error_counters[error] += 1
    errors_per_shard[error + '.' + message[1]] += 1

for error, n in error_counters.iteritems():
    print('total_error_count_{} {}'.format(error, n))

for metric, n in errors_per_shard.items():
    print('{} {}'.format(metric, n))
