{% set cluster = pillar.get('cluster') %}


{% for file in pillar.get('mpfs-common-files', []) %}
{{file}}:
  yafile.managed:
    - source: salt://units/mpfs/files{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

#cluster-specific files (configs etc)
{% for file in pillar.get('mpfs-files', []) %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - source: salt://units/mpfs/files{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

{% for file in pillar.get('mpfs-exec-files', []) %}
{{file}}:
  yafile.managed:
    - source: salt://units/mpfs/files{{ file }}
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

mpfs-extra-pkgs:
  pkg.installed:
    - pkgs:
      {% for pkg in pillar.get('mpfs-extra-pkgs', []) %}
      - {{ pkg }}
      {% endfor %} 

pingunoque:
  service:
    - running
    - reload: False

pymongo-bson-zero-size:
  monrun.present:
    - command: '/usr/lib/yandex/disk/mpfs/pymongo-bson-zero-size.sh /var/log/mpfs/error-tskv.log 1200 50'
    - execution_interval: 120
    - execution_timeout: 30
    - type: mongodb


/etc/yandex/disk-secret-keys.yaml:
  file.managed:
    - contents_pillar: mpfs-yav-secrets:disk-secret-keys.yaml
    - mode: 440 
    - user: root
    - group: nginx
    - makedirs: True


/etc/yandex/disk-mpfs-token:
  file.managed:
    - contents_pillar: mpfs-yav-secrets:disk-mpfs-token-{{ grains.get('yandex-environment') }}
    - mode: 440 
    - user: root
    - group: nginx
    - makedirs: True


/etc/yandex/mpfs/access_overrides.yaml:
  file.managed:
    - contents_pillar: mpfs-yav-secrets:access_overrides.yaml-{{ grains.get('conductor')['group'] }}
    - mode: 440
    - user: root
    - group: nginx
    - makedirs: True

/etc/nginx/keys/tvm-asymmetric.public:
  file.managed:
    - contents_pillar: mpfs-yav-secrets:tvm-asymmetric.public
    - mode: 440 
    - user: root
    - group: nginx
    - makedirs: True

monrun-lighttpd_3132:
  monrun.present:
    - name: lighttpd_3132
    - file: /etc/monrun/conf.d/lighttpd3132.conf
    - execution_interval: 300
    - command: '/usr/bin/jhttp.sh -u /ping_pattern -p 3132 -t 10 --antiflap'

