{% set cluster = pillar.get('cluster') %}
{% set unit = 'pingunoque' %}

{% for file in pillar.get('pingunoque-config-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - template: jinja
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
    - follow_symlinks: True
{% endfor %}

#pingunoque:
#  pkg:
#    - installed
#  service:
#    - running
#    - reload: True

pingunoque:
  pkg.installed:
    - pkgs: {{ salt['conductor.package']('pingunoque') }}
  service.running:
    - require:
      - pkg: pingunoque
