{% set cluster = pillar.get('cluster') %}
{% set unit = 'squid3' %}

{% for file in pillar.get('squid3-exec-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

{% for file in pillar.get('squid3-monrun-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 644 
    - user: root
    - group: root
    - makedirs: True
    - watch_in: monrun-regenerate
{% endfor %}

{% for file in pillar.get('squid3-config-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 644 
    - template: jinja
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

{% for link, target in pillar.get('squid3-symlinks').items() %}
{{ link }}:
  file.symlink:
    - target: {{ target }}
    - makedirs: True
    - force: True
{% endfor %}

squid:
  service:
    - running
    - reload: True
    - require:
      - pkg: squid
  pkg:
    - installed
    - pkgs:
      - squid3
      - squid-common
