#!/usr/bin/perl                                                                                                                                                                                                                      

use warnings;
use strict;

use Sys::Hostname;
use Date::Parse;
use Date::Format;

$| = 1;

my ($host, $format) = (hostname(), $ARGV[0]);

while (<STDIN>) {
    if (/^((?:\d+;){3})\[([^\]]+)\](.* ([0-9.]+)ms.*|.*)$/) {
        my $t = str2time($2);
        printf
            "%stskv\ttskv_format=%s\ttimestamp=%s\ttimezone=%s\thost=%s\tmessage=%s\ttime_spent=%s\n",
            $1,
            $format,
            time2str("%Y-%m-%d %X", $t),
            time2str("%z", $t),
            $host,
            $3,
            $4 || '';
    }
}
