#!/bin/bash
PID=$(pgrep -f "push-client -f -w")
[ -z "$PID" ] && echo "2;Push-client not running" && exit 0

COMMAND=$(ps --no-headers -w -o cmd $PID)
CONFIGS=( ${COMMAND#*-c } )
CONFIGS=${CONFIGS[@]#-c}

[ -z "$CONFIGS" ] && echo "2; Push-client not running" && exit 0

for i in $CONFIGS; do
    if ! pgrep -P $PID -f "push-client.* -c $i" > /dev/null; then
        echo "2; Push-client not running"
        exit 0
    fi

    STATUS=$(push-client --status -c $i 2>&1 | awk '/status:/{print $NF}')
    case $STATUS in
        "ok") ;;
        "warn") echo "1; Push-client status is $STATUS"
              exit 0
              ;;
             *) echo "2; Push-client status is $STATUS"
              exit 0
              ;;

    esac
done

echo "0; ok"
