#!/usr/bin/env python

# -*- coding: UTF-8 -*-

import os
import re
import sys

results_errors = { 'parse' : 0 }

s_name = 'xmpp';

meters_patterns = { 
    'auth_failure' : ['Auth failure'],
    'auth_error' : ['Auth error'],
    'auth_successful' : ['Successful auth'],
    'session_term' : ['Terminating'],
    'unexpected_message' : ['Unexpected message'],
    'accepted_new_connection' : ['Accepted new connection'],
    'push' : ['Push'],
    'pack' : ['PAck'],
    'ping' : ['Ping id'],
    'summary' : ['Summary'],
    'status' : ['Status']
}

patterns_meters = dict();
for meter,patterns in meters_patterns.items():
    for pattern in patterns:
        patterns_meters[pattern] = meter
meters_patterns['others'] = None

# 
#count_patterns = ['auth_failure', 'auth_successful', 'session_term', 'unexpected_message', 'others', 'accepted_new_connection', 'push', 'ping']
count_patterns = meters_patterns.keys()


# codes
results_count_patterns = dict() 
for mu_key in count_patterns:
    results_count_patterns[mu_key] = 0

log_re = re.compile('\[xmpp\]: ([^:=]+)')


for line in sys.stdin:

    parts = line.strip("\n")
    log_matches = log_re.findall(parts)
    if len(log_matches):

        b_pattern = log_matches[0]
        if b_pattern in patterns_meters:
            u_pattern = patterns_meters[b_pattern]
        else:
	    print line
            u_pattern = 'others'

        if u_pattern in count_patterns:
            results_count_patterns[u_pattern] += 1

    else:
        results_errors['parse'] += 1
#        print line
        continue

# aggregate
for u_pattern, result in sorted(results_count_patterns.items()):
    print ("{}_count_{} {}".format(s_name, u_pattern, result))

for error, value in sorted(results_errors.items()):
    print("{}_error_{} {}".format(s_name, error, value))



sys.exit(0)

