#!/usr/bin/env python

# -*- coding: UTF-8 -*-

import os
import re
import sys
import subprocess
import shlex
import httplib
import pprint
from collections import defaultdict
import json


meters_urls_json = { 
    'xmpp_stats' : ['GET', '/stats/xmpp?json'],
}

results_sensors = defaultdict(int)

#collect
conn = httplib.HTTPConnection('127.0.0.1', 8080)
for url in meters_urls_json:
    conn.request(meters_urls_json[url][0], meters_urls_json[url][1])
    data = json.load(conn.getresponse())
    for meter in data['pushes']:
        results_sensors[meter] = int(data['pushes'][meter])
    
conn.close()

#aggr

#print
for sensor, value in sorted(results_sensors.items()):
    print("%s %d" % (sensor, value))

sys.exit(0)

