{% set cluster = pillar.get('cluster') %}
{% set unit = 'yandex-disk-log-reader' %}

/etc/yandex/disk/log-reader/application.properties:
  yafile.managed:
    - source: salt://units/{{ unit }}/files/etc/yandex/disk/log-reader/application.properties
    - mode: 644
    - user: root
    - group: root
    - makedirs: True

/etc/yandex/disk/log-reader/application-secret.properties:
  file.managed:
    - contents_pillar: {{ unit }}-application-secret-properties
    - mode: 440
    - user: root
    - group: root
    - makedirs: True

yandex-disk-log-reader:
  service:
    - running
  pkg:
    - installed

