#!/usr/bin/python
import sys
import re
from collections import Counter
from string import maketrans

logline_pattern = re.compile(r'(?P<timestamp>[0-9/ :.]+) \[(?P<severity>[a-zA-Z]+)\]'
                             r' (?P<pid>[0-9#]+): \*(?P<cid>[0-9]+) (?P<message>.*)')

request_pattern = re.compile(r'.*, request: "[A-Z]+ /(?P<location>.*?)[/?].*')

url_errors = Counter()
all_errors = Counter()
total_errors = 0

for read_line in sys.stdin:
    read_line = read_line.strip()
    total_errors += 1

    parsed_line = re.match(logline_pattern, read_line)
    message = parsed_line.group('message')

    all_errors[message.split(',')[0]] += 1

    if 'request' in message:
        request_match = re.match(request_pattern, message)
        location = request_match.group('location')
        url_errors[location] += 1

in_tab = '():. ,'
out_tab = '_' * len(in_tab)
tran_tab = maketrans(in_tab, out_tab)

print 'nginx_error_total {}'.format(total_errors)

for url, errors in url_errors.items():
    print 'nginx_error_url_{} {}'.format(url, errors)

for error, count in all_errors.items():
    print 'nginx_error_message_{} {}'.format(error.translate(tran_tab), count)
