#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import re
import sys
from collections import Counter, defaultdict


def tskv_get_key(line, key):
    key_index = line.find('\t%s=' % key)
    return line[key_index + (len(key)+2):].split('\t')[0]


def metric_name(*args):
    return '_'.join(map(str, args))


results_errors_parse = 0
results_count_codes = Counter()
results_count_urls = Counter()
results_timings_urls = defaultdict(Counter)

meters_urls = {
    'get_zip-folder': ['GET /zip-folder'],
    'post_upload-from-service': ['POST /upload-from-service'],
    'get_zip-folder-public': ['GET /zip-folder-public'],
    'get_regenerate-preview': ['GET /regenerate-preview'],
    'put_patch-target': ['PUT /patch-target'],
    'post_patch-target': ['POST /patch-target'],
    'get_patch-installer': ['GET /patch-installer'],
    'post_patch-url': ['POST /patch-url'],
    'get_request-status': ['GET /request-status'],
    'post_upload-url': ['POST /upload-url'],
    'head_upload-target': ['HEAD /upload-target'],
    'put_upload-target': ['PUT /upload-target'],
    'post_upload-target': ['POST /upload-target'],
    'get_generate-preview': ['GET /generate-preview'],
    'loading-status': ['GET /loading-status', 'POST /loading-status'],
}

urls_meters = dict()
for meter, urls in meters_urls.items():
    for url in urls:
        urls_meters[url] = meter

url_re = re.compile(r'(\/[^\/?]*)?[\/?].*')


for line in sys.stdin:
    line = line.strip()
    if not line:
        continue

    request = tskv_get_key(line, 'request')
    method = tskv_get_key(line, 'method')
    matches = url_re.search(request)
    if not matches:
        results_errors_parse += 1
        continue
    b_url = '%s %s' % (method, matches.group(1))
    u_code = tskv_get_key(line, 'status')
    u_time = tskv_get_key(line, 'request_time')

    u_url = urls_meters.get(b_url, 'others')
    g_code = 'code_%sxx' % u_code[0]
    results_count_codes[u_code] += 1
    results_count_codes[g_code] += 1
    results_count_urls[metric_name(u_url, u_code)] += 1
    results_count_urls[metric_name(u_url, g_code)] += 1
    results_count_urls[metric_name(u_url, 'all')] += 1
    results_timings_urls[u_url][u_time] += 1


for u_url_code, value in sorted(results_count_urls.items()):
    print("uploader_count_request_%s %d" % (u_url_code, value))

for u_code, value in sorted(results_count_codes.items()):
    print("uploader_count_request_total_%s %d" % (u_code, value))

for u_url, timings in sorted(results_timings_urls.items()):
    if timings:
        packed_timings = map(lambda t: "%s@%s" % t, sorted(timings.items()))
        print("@uploader_timings_request_%s %s" % (u_url, ' '.join(packed_timings)))

if results_errors_parse:
    print("uploader_count_access_error_parse %d" % results_errors_parse)
