{% set cluster = pillar.get('cluster') %}
{% set unit = 'yandex-disk-uploader' %}


{% for file in pillar.get('yandex-disk-uploader-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

{% for file in pillar.get('yandex-disk-uploader-exec-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

/usr/local/bin/heiftojpeg:
  file.managed:
    - source: https://proxy.sandbox.yandex-team.ru/720088820
    - source_hash: 0958d976d5c8a22bb04e85f8d225ea82
    - mode: 755
    - user: root
    - group: root
    - makedirs: True

{% for file in pillar.get('yandex-disk-uploader-monrun-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 644 
    - user: root
    - group: root
    - makedirs: True
    - watch_in: monrun-regenerate
{% endfor %}

{% for file in pillar.get('yandex-disk-uploader-config-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 644 
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

{% for link, target in pillar.get('yandex-disk-uploader-symlinks').items() %}
{{ link }}:
  file.symlink:
    - target: {{ target }}
    - makedirs: True
    - force: True
    - require:
      - yafile: {{ target }}
{% endfor %}

/etc/yandex/disk/uploader/application-secret.properties:
  file.managed:
    - contents_pillar: {{ unit }}-application-secret-properties
    - mode: 440
    - user: root
    - group: root
    - makedirs: True

yandex-disk-uploader:
  service:
    - running
  pkg:
    - installed

