{% set cluster = pillar.get('cluster') %}
{% set unit = 'yandex-ipset-persistent' %}

{% for file in pillar.get('yandex-ipset-persistent-config-files') %}
{{file}}:
  yafile.managed:
    - source: salt://units/{{ unit }}/files{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
    - watch_in: ipset-persistent-reload-cmd
{% endfor %}

ipset-persistent-reload-cmd:
  cmd.wait:
    - name: '/etc/init.d/ipset-persistent reload'
    - cwd: /


ipset-persistent:
  service.enabled:
    - require:
      - pkg: ipset-persistent
  pkg.installed:
    - pkgs:
      - yandex-ipset-persistent
      - ipset
